using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class OcTreeWalker<T,D>:TreeWalker<OcTreeNode<T,D>>
  { 
    public override OcTreeNode<T,D> Parent( OcTreeNode<T,D> node )
    {
      if ( node is OcTree<T,D> )
      {
        return null;
      }

      var cell = node as OcTreeCell<T,D>;

      return cell.isRoot ? cell.tree : cell.parent;
    }

    public override int NumChildren( OcTreeNode<T,D> node )
    {
      if ( node is OcTree<T,D> tree )
      {
        return tree.rootCells.Count;
      }

      var cell = node as OcTreeCell<T,D>;

      return cell.numCells;
    }

    public override OcTreeNode<T,D> ChildAt( OcTreeNode<T,D> node, int index )
    {
      if ( index < 0 || index >= NumChildren( node ) )
      {
        return null;
      }
      
      if ( node is OcTree<T,D> tree )
      {
        return tree.rootCells[ index ];
      }

      var cell = node as OcTreeCell<T,D>;

      return cell.cells[ index ];
    }
  }
}