using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class QuadTreeWalker<T,D>:TreeWalker<QuadTreeNode<T,D>>
  { 
    public override QuadTreeNode<T,D> Parent( QuadTreeNode<T,D> node )
    {
      if ( node is QuadTree<T,D> )
      {
        return null;
      }

      var cell = node as QuadTreeCell<T,D>;

      return cell.isRoot ? cell.tree : cell.parent;
    }

    public override int NumChildren( QuadTreeNode<T,D> node )
    {
      if ( node is QuadTree<T,D> tree )
      {
        return tree.rootCells.Count;
      }

      var cell = node as QuadTreeCell<T,D>;

      return cell.numCells;
    }

    public override QuadTreeNode<T,D> ChildAt( QuadTreeNode<T,D> node, int index )
    {
      if ( index < 0 || index >= NumChildren( node ) )
      {
        return null;
      }
      
      if ( node is QuadTree<T,D> tree )
      {
        return tree.rootCells[ index ];
      }

      var cell = node as QuadTreeCell<T,D>;

      return cell.cells[ index ];
    }
  }
}