using Godot;

using System.Collections.Generic;
using System;
using System.Threading.Tasks;
using System.Reflection;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class CheckTransforms:DebugAction
  {
    protected new const string name = "Check Transforms";

    [Export]
    public Node[] roots = [];


    int _numProcessed = 0;

    protected override void _OnTrigger()
    {
      ClearMessages();

      _numProcessed = 0;

      var id = DispatchStart();


      roots.ForEach(
        ( r )=>
        {
          Nodes.ForEach<Node3D>( r, n => CheckTransformsOf( n ) );
        }
      );

      UpdateStatus( "Processed: " + _numProcessed );

      FinishMessages();
      DispatchEnd( id );
    }

    void CheckTransformsOf( Node3D node3D )
    {
      if ( ! Math3D.IsValid( node3D.GlobalPosition ) )
      {
        Error( node3D, "GlobalPosition not valid", node3D.GlobalPosition );
      }

      if ( ! Math3D.IsValid( node3D.Position ) )
      {
        Error( node3D, "Position not valid", node3D.Position );
      }

      if ( ! Math3D.IsValid( node3D.GlobalRotation ) )
      {
        Error( node3D, "GlobalRotation not valid", node3D.GlobalRotation );
      }

      if ( ! Math3D.IsValid( node3D.Rotation ) )
      {
        Error( node3D, "Rotation not valid", node3D.Rotation );
      }

      if ( ! Math3D.IsValid( node3D.Scale ) )
      {
        Error( node3D, "Scale not valid", node3D.Scale );
      }

      if ( Math3D.IsZero( node3D.Scale ) )
      {
        Error( node3D, "Scale is zero", node3D.Scale );
      }

      _numProcessed ++;
    }
    

  }
}