using Godot;

using System.Collections.Generic;
using System;
using System.Threading.Tasks;
using System.Reflection;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class CheckWarnings:DebugAction
  {
    protected new const string name = "Check Warnings";

    [Export]
    public Node[] roots = [];

    int _numProcessed = 0;

    protected override void _OnTrigger()
    {
      ClearMessages();

      _numProcessed = 0;

      var id = DispatchStart();


      roots.ForEach(
        ( r )=>
        {
          Nodes.ForEach<Node>( r, n => CheckWarningsOf( n ) );
        }
      );

      UpdateStatus( "Processed: " + _numProcessed );

      FinishMessages();
      DispatchEnd( id );
    }

    void CheckWarningsOf( Node n )
    {
      var warnings = n._GetConfigurationWarnings();

      if ( warnings != null && warnings.Length > 0 )
      {
        Warning( n, "Has " + warnings.Length + " warnings");
      }

      _numProcessed ++;
    }
  }
}