using Godot;

using System.Collections.Generic;
using System;
using System.Threading.Tasks;
using System.Reflection;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class DebugMessage:Resource
  {
    [Export]
    public MessageType type;

    [Export(PropertyHint.MultilineText)]
    public string content;

    [ExportToolButton( "Show Node")]
    public Callable ShowNodeButton => Callable.From(
      ( ) =>
      {
        if ( node == null )
        {
          return;
        }

        

        #if TOOLS

        var root = EditorInterface.Singleton.GetEditedSceneRoot();

        var resolvedNode = root.GetNode( node );

        if ( resolvedNode == null )
        {
          this.LogError( "Couldn't resolve node", node );
          return;
        } 

        this.LogInfo( resolvedNode );
        // var selection = EditorInterface.Singleton.GetSelection();
        // selection.Clear();
        // selection.AddNode( resolvedNode );

        EditorInterface.Singleton.InspectObject( resolvedNode ); 


        #endif
      }
    );
    
    [Export]
    public NodePath node;

    [Export]
    public Resource resource;

  }
}