using System.Collections;
using System.Collections.Generic;

using System.Text;


namespace Rokojori
{
 
  public class JSON
  {
    public static string Stringify( JSONData jsonData )
    {
      return jsonData.Stringify();
    }

    public static void Save( string path, JSONData data )
    {
      FilesSync.SaveUTF8( path, Stringify( data ) );
    }

    public static JSONData Parse( string jsonString )
    {
      return new JSONParser().Parse( jsonString );
    }

    public static JSONData Load( string path )
    {
      return JSON.Parse( FilesSync.LoadUTF8( path ) );
    }
    
    public static string StringifyObject( object value )
    {
      var serializer = new JSONSerializer( new JSONSerializationSettings() );
      return serializer.Serialize( value );
    }

    public static T ParseObject<T>( string jsonString ) where T:new()
    {
      var deserializer = new JSONDeserializer( new JSONSerializationSettings() );
      return deserializer.Deserialize<T>( jsonString );
    }

  }
}