using System.Collections;
using System.Collections.Generic;

using System.Text;




namespace Rokojori
{
  public class JSONArray:JSONData
  {
    List<JSONData> _values = new List<JSONData>();

    public override JSONDataType dataType 
    {
      get { return JSONDataType.ARRAY; }
    }

    public List<JSONData> values { get { return _values; }}
   
    public int size { get { return _values.Count; } }
    
    public JSONData Get( int index )     
    {
      return _values[ index ];
    }    

    

    public void Delete( int index )
    {
      _values.RemoveAt( index );
    }

    public List<float> AsFloatList()
    {
      var list = new List<float>();
      values.ForEach( v => list.Add( (float) v.numberValue ) );
      return list;
    }

    public void Push( JSONData value ) {_values.Add( value );}

    public void Push( string value ) { Push( new JSONValue( value ) ); }
    public void Push( double value ) { Push( new JSONValue( value ) ); }
    public void Push( bool value ) { Push( new JSONValue( value ) ); }

    public void Set( int index, JSONData data )
    {
      while ( index >= _values.Count )
      {
        Push( new JSONValue( null ) );
      }
      _values[ index ] = data;
    }

    public void Set( int index, string value ) { Set( index, new JSONValue( value ) ); }
    public void Set( int index, bool value ) { Set( index, new JSONValue( value ) ); }
    public void Set( int index, double value ) { Set( index, new JSONValue( value ) ); }

    public JSONData this[ int index ]
    {
        get { return Get( index ); }
        set { Set( index, value ); }
    }
    
    public JSONData Pop()
    {
      return Lists.PopLast( _values );
    }

    public override string Stringify( StringifyOptions options )
    {
      var builder = new StringBuilder();

      if ( values.Count == 0) 
      {
        options.increaseIndent();
        builder.Append( "[]" );
        options.decreaseIndent();
        return builder.ToString();
      }

      options.increaseIndent();
      builder.Append( "[\n" );
      if ( values.Count > 0 )
      {
        builder.Append( options.indent );
        builder.Append( values[ 0 ].Stringify( options ) );
      }

      for ( var i = 1; i < values.Count; i++ )
      {
        builder.Append( ",\n" );
        builder.Append( options.indent );
        builder.Append( values[ i ].Stringify( options ) );
      }
      
      options.decreaseIndent();
      builder.Append( "\n" );
      builder.Append( options.indent );
      builder.Append( "]" );
      return builder.ToString();
    }


  }
}