using System.Collections;
using System.Collections.Generic;

using System.Text;



namespace Rokojori
{
  public class JSONValue:JSONData
  {
    JSONDataType _dataType;
    double _numberValue = 0;
    bool _booleanValue = false;
    string _stringValue = ""; 

    public override JSONDataType dataType 
    {
      get { return _dataType; }
    }   

    public JSONValue(){ SetNull(); }
    public JSONValue( string value ){ Set( value ); }
    public JSONValue( double value ){ Set( value ); }
    public JSONValue( long value ){ Set( value ); }
    public JSONValue( bool value ){ Set( value ); }
    

    private void Set( double number )
    {
      _numberValue = number;
      _dataType = JSONDataType.NUMBER;
    }

    private void Set( long number )
    {
      _numberValue = number;
      _dataType = JSONDataType.NUMBER;
    }

    private void Set( string value )
    {
      _stringValue = value;
      _dataType = value == null ? JSONDataType.NULL : JSONDataType.STRING;
    }

    private void Set( bool flag )
    {
      _booleanValue = flag;
      _dataType = JSONDataType.BOOLEAN;
    }

    private void SetNull()
    {
      _dataType = JSONDataType.NULL;
    }

    public double GetNumberValue(){  return _numberValue;  }
    public float GetFloatValue() { return (float) _numberValue; }
    public int GetIntValue(){ return (int) System.Math.Round( _numberValue ); }
    public long GetLongValue(){ return (int) System.Math.Round( _numberValue ); }
    public bool GetBooleanValue(){  return _booleanValue;  }
    public string GetStringValue(){ return _stringValue;  }
    public T GetEnumFromString<T>( T enumValue ) where T : System.Enum
    {
      //System.Enum.TryParse( _stringValue, out T enumValue);
      return enumValue;
    }

    public override string Stringify( StringifyOptions options )
    {
      if ( JSONDataType.STRING == _dataType  )
      {
        var output = new StringBuilder();
        JSONStringConverter.Write( output, _stringValue, 0, _stringValue.Length );
        return output.ToString();
      }
      else if ( JSONDataType.NUMBER == _dataType )
      {
        return RegexUtility.NumberToString( _numberValue );
      }
      else if ( JSONDataType.BOOLEAN == _dataType )
      {
        return _booleanValue ? "true" : "false"; 
      }

      return "null";
    }
  }
}