using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Globalization;
using System;





namespace Rokojori
{ 
  public class BigIntegerSerializer: CustomSerializer
  {
    public override List<Type> HandlingTypes()
    {
      return new List<Type>(){ typeof( System.Numerics.BigInteger ) };
    }
    

    public override JSONData Serialize( object value )
    {
      var bigInteger = (System.Numerics.BigInteger) value;      
      return new JSONValue( bigInteger.ToString( "R" ) );
    } 

    public override void Deserialize( JSONData data, Reference referenceRelation )
    {
      if ( referenceRelation.target == null )
      {
        return;
      }

      var bigInteger = System.Numerics.BigInteger.Parse( data.stringValue );
      
      referenceRelation.AssignValue( bigInteger );
    } 
  } 
}