using System.Collections;
using System.Collections.Generic;

using System.Text;
using System.Globalization;
using System;

using Godot;





namespace Rokojori
{ 
  public class ColorSerializer: CustomSerializer
  {
    public override List<Type> HandlingTypes()
    {
      return new List<Type>(){ typeof( Color ) };
    }
    

    public override JSONData Serialize( object value )
    {
      var color = (Color) value; 
      var jsonArray = new JSONArray();
      jsonArray.Push( color.R );
      jsonArray.Push( color.G );
      jsonArray.Push( color.B );
      jsonArray.Push( color.A );

      return jsonArray;
    } 

    public override void Deserialize( JSONData data, Reference referenceRelation )
    {
      if ( referenceRelation.target == null )
      {
        return;
      }
      var array = data.AsArray();

      var color = new Color( 
        array.Get( 0 ).floatValue, 
        array.Get( 1 ).floatValue, 
        array.Get( 2 ).floatValue, 
        array.Get( 3 ).floatValue
      );
      
      referenceRelation.AssignValue( color );
    } 
  } 
}