using System.Collections;
using System.Collections.Generic;

using System.Text;
using System.Globalization;
using System;





namespace Rokojori
{ 
  public class DateTimeSerializer: CustomSerializer
  {
    public override List<Type> HandlingTypes()
    {
      return new List<Type>(){ typeof( DateTime ) };
    }
    

    public override JSONData Serialize( object value )
    {
      var dateTime = (DateTime) value;      
      return new JSONValue( dateTime.ToString( "o" ) );
    } 

    public override void Deserialize( JSONData data, Reference referenceRelation )
    {
      if ( referenceRelation.target == null )
      {
        return;
      }

      var dateTime = System.DateTime.Parse( data.stringValue,  
                                            CultureInfo.InvariantCulture, 
                                            DateTimeStyles.RoundtripKind );
      
      referenceRelation.AssignValue( dateTime );
    } 
  } 
}