using System.Collections;
using System.Collections.Generic;

using System.Text;



using System;


namespace Rokojori
{ 
  public class JSONSerializationSettings
  {
    public static readonly string NUMBER_TYPE = "number-type";
    public static readonly string NUMBER_VALUE = "number-value";
    public static readonly string INT_NUMBER_TYPE = "int";
    public static readonly string FLOAT_NUMBER_TYPE = "float";
    public static readonly string DOUBLE_NUMBER_TYPE = "double";
    public static readonly string LONG_NUMBER_TYPE = "long";

    static List<Type> serializableDictionaryKeyTypes = new List<Type>()
    {
      typeof( string ), typeof( int )
    };

    public static readonly List<CustomSerializer> defaultSerializers = new List<CustomSerializer>()
    {
      new DateTimeSerializer(),
      new BigIntegerSerializer()
    };


    public static bool IsSerializableDictionary( Type type )
    {
      if ( ! ReflectionHelper.IsDictionary( type ) )
      {
        return false;
      }

      var keyType = type.GetGenericArguments()[ 0 ];

      return serializableDictionaryKeyTypes.IndexOf( keyType ) != -1;
    }


    public static bool IsSerializableDictionary( object value )
    {
      if ( ! ReflectionHelper.IsDictionary( value ) )
      {
        return false;
      }

      var keyType = value.GetType().GetGenericArguments()[ 0 ];

      return serializableDictionaryKeyTypes.IndexOf( keyType ) != -1;
    }


    public List<CustomSerializer> customSerializers = new List<CustomSerializer>();
    public bool saveNumbersWithType = false;
    public bool throwErrorOnCycles = false;


  }

}