using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class CSharpLexer:Lexer
  {
    public static List<LexerEvent> Lex( string source )
    {
      var lexer = new CSharpLexer();
      var events = lexer.LexToList( source );      

      if ( lexer.hasError )
      {
        return null;
      }

      events.ForEach( ev => { ev.GrabMatch( source ); } );
      return events;
    }

    public static List<List<LexerEvent>> GetAllObjectDefinitions( string source )
    {
      var tokens = Lex( source ).Filter( e => ! ( e.isDone || e.isError ) );

      var sequences = LexerEvent.FindSequences( tokens,         
        ( int index, bool inSequence ) =>
        {
          var le = tokens[ index ];

          if ( 

            le.Is( LexerMatcherLibrary.ClassMatcher ) ||
            le.Is( LexerMatcherLibrary.StructMatcher ) ||
            le.Is( LexerMatcherLibrary.InterfaceMatcher ) ||
            le.Is( LexerMatcherLibrary.RecordMatcher ) ||
            le.Is( LexerMatcherLibrary.EnumMatcher ) 
          )
          {
            return Trillean.True;
          }
          
          if ( inSequence && le.Is( LexerMatcherLibrary.CwordMatcher ) )
          {
            return Trillean.False;
          }

          return Trillean.Any;
        } 
      );

      return sequences;
    }

    public CSharpLexer()
    {
      AddAllMatchers(
        LexerMatcherLibrary.SingleLineCommentMatcher,
        LexerMatcherLibrary.MultiLineCommentMatcher,
        LexerMatcherLibrary.DoubleQuotedStringMatcher,
        LexerMatcherLibrary.SingleQuotedStringMatcher,
        LexerMatcherLibrary.CInstructionMatcher,
        LexerMatcherLibrary.NumberMatcher,
        LexerMatcherLibrary.NullMatcher,
        LexerMatcherLibrary.BoolMatcher,
        LexerMatcherLibrary.BreakMatcher,
        LexerMatcherLibrary.WhiteSpaceMatcher,
        LexerMatcherLibrary.LogicMatcher,
        LexerMatcherLibrary.BracketMatcher,
        LexerMatcherLibrary.AccessModifierMatcher,
        LexerMatcherLibrary.ClassMatcher,
        LexerMatcherLibrary.EnumMatcher,
        LexerMatcherLibrary.StructMatcher,
        LexerMatcherLibrary.InterfaceMatcher,
        LexerMatcherLibrary.RecordMatcher,
        LexerMatcherLibrary.OperatorMatcher,
        LexerMatcherLibrary.CFunctionMatcher,
        LexerMatcherLibrary.CwordMatcher,
        LexerMatcherLibrary.AnySymbolMatcher
      );
    }
  }
}