using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class GDShaderLexer:Lexer
  {
    public static List<LexerEvent> Lex( string source )
    {
      var lexer = new GDShaderLexer();
      var events = lexer.LexToList( source );      

      if ( lexer.hasError )
      {
        return null;
      }

      events.ForEach( ev => { ev.GrabMatch( source ); } );
      return events;
    }

    public static readonly LexerMatcher RenderSettingsFlagMatcher = 
      new LexerMatcher( "RenderSettingsFlag", @"\b(?:shader_type|render_mode)\b" );

    public static readonly LexerMatcher TypeMatcher = 
      new LexerMatcher( "ShaderType", @"\b(?:spatial|canvas_item|particles|sky|fog)\b" );

    public static readonly LexerMatcher UsageMatcher = 
      new LexerMatcher( "Usage", @"\b(?:uniform|varying)\b" );

    public static readonly LexerMatcher InOutMatcher = 
      new LexerMatcher( "InOut", @"\b(?:inout|in|out)\b" );
    // public static readonly LexerMatcher RenderModeMatcher = 
    //   new LexerMatcher( "RenderMode", @"\b(?:spatial|canvas|particles)\b" );

    public static LexerMatcher[] ignore =  
    [ 
      LexerMatcherLibrary.SingleLineCommentMatcher,
      LexerMatcherLibrary.MultiLineCommentMatcher,
      LexerMatcherLibrary.BreakMatcher,
      LexerMatcherLibrary.WhiteSpaceMatcher
    ];

    public GDShaderLexer()
    {
      AddAllMatchers(
        LexerMatcherLibrary.SingleLineCommentMatcher,
        LexerMatcherLibrary.MultiLineCommentMatcher,
        LexerMatcherLibrary.DoubleQuotedStringMatcher,
        LexerMatcherLibrary.CInstructionMatcher,
        RenderSettingsFlagMatcher,
        TypeMatcher,
        UsageMatcher,
        InOutMatcher,
        LexerMatcherLibrary.NumberMatcher,
        LexerMatcherLibrary.BoolMatcher,
        LexerMatcherLibrary.BreakMatcher,
        LexerMatcherLibrary.WhiteSpaceMatcher,
        LexerMatcherLibrary.LogicMatcher,
        LexerMatcherLibrary.BracketMatcher,
        LexerMatcherLibrary.AccessModifierMatcher,
        LexerMatcherLibrary.StructMatcher,
        LexerMatcherLibrary.OperatorMatcher,
        LexerMatcherLibrary.CFunctionMatcher,
        LexerMatcherLibrary.CwordMatcher,
        LexerMatcherLibrary.AnySymbolMatcher
      );
    }
  }
}