using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{
  public class LexerMatcherLibrary
  {
    public static readonly LexerMatcher CwordMatcher = 
      new LexerMatcher( "CWord", @"[a-zA-Z_]\w*" );
    
    public static readonly LexerMatcher CFunctionMatcher = 
      new LexerMatcher( "CFunction", @"[a-zA-Z_]\w*(?=\s*\()" );

    public static readonly LexerMatcher JSWordMatcher = 
      new LexerMatcher( "JSWord", @"[a-zA-Z_\$]\w*" );

    public static readonly LexerMatcher PHPWordMatcher = 
      new LexerMatcher( "PHPWord", @"\$?[a-zA-Z_]\w*" );


    public static readonly LexerMatcher CSS_ClassSelectorMatcher = 
      new LexerMatcher( "CSS_ClassSelector", @"\.[a-zA-Z_](\w|\-)*" );

    public static readonly LexerMatcher CSS_IDSelectorMatcher = 
      new LexerMatcher( "CSS_IDSelector", @"\#[a-zA-Z_](\w|\-)*" );

    public static readonly LexerMatcher CSS_WordMatcher = 
      new LexerMatcher( "CSS_Word", @"[a-zA-Z_](\w|\-)*" );


    public static readonly LexerMatcher HTML_CustomElementMatcher =
      new LexerMatcher( "HTML_CustomElement", @"[a-zA-Z]\w*\-(\w|\-)+" );

    public static readonly LexerMatcher DoubleQuotedStringMatcher = 
      new LexerMatcher( "DoubleQuotedString", "\"(?:[^\"\\\\]|\\\\.)*\"" );

    public static readonly LexerMatcher SingleQuotedStringMatcher = 
      new LexerMatcher( "SingleQuotedString", @"'(?:[^'\\]|\\.)*'" );

    public static readonly LexerMatcher NumberMatcher = 
      new LexerMatcher( "Number", @"(?=\.\d|\d)(?:\d+)?(?:\.?\d*)(?:[eE][+-]?\d+)?" );

    public static readonly LexerMatcher WhiteSpaceMatcher = 
      new LexerMatcher( "WhiteSpace", @"\s+" );
    
    public static readonly LexerMatcher BreakMatcher = 
      new LexerMatcher( "Break", @"(\r\n|\r|\n)" );
      

    public static readonly LexerMatcher NullMatcher = 
      new LexerMatcher( "Null", "null" );

    public static readonly LexerMatcher BoolMatcher = 
      new LexerMatcher( "Bool", "true|false" );

    public static readonly LexerMatcher LogicMatcher = 
      new LexerMatcher( "Logic", "if|else|switch|do|while|for|break|continue|return" );

    public static readonly LexerMatcher OperatorMatcher = 
      new LexerMatcher( "Operator", "(?:\\=\\=)|(?:\\+\\+)|(?:\\-\\-)|(?:\\+\\=)|(?:\\*\\=)|(?:\\-\\=)|(?:\\/\\=)|\\+|\\-|\\*|\\/|\\^|\\||\\~|\\&|\\%|\\<|\\>|\\=|\\!|\\.|\\:|\\,|\\;" );  

    public static readonly LexerMatcher BracketMatcher = 
      new LexerMatcher( "Bracket", @"\(|\)|\[|\]|\{|\}" );

    public static readonly LexerMatcher BlockStartMatcher = 
      new LexerMatcher( "BlockStart", @"\{" );

    public static readonly LexerMatcher BlockEndMatcher = 
      new LexerMatcher( "BlockStart", @"\}" );

    public static readonly LexerMatcher ClassMatcher = 
      new LexerMatcher( "Class", @"\bclass\b" );

    public static readonly LexerMatcher EnumMatcher = 
      new LexerMatcher( "Enum", @"\benum\b" );

    public static readonly LexerMatcher InterfaceMatcher = 
      new LexerMatcher( "Interface", @"\binterface\b" );

    public static readonly LexerMatcher StructMatcher = 
      new LexerMatcher( "Struct", @"\bstruct\b" );

    public static readonly LexerMatcher RecordMatcher = 
      new LexerMatcher( "Record", @"\brecord\b" );

    public static readonly LexerMatcher AccessModifierMatcher = 
      new LexerMatcher( "AccessModifier", @"\b(?:public|protected|private|const)\b" );

    public static readonly LexerMatcher SingleLineCommentMatcher = 
      new LexerMatcher( "SingleLineComment", @"//.*" );

    public static readonly LexerMatcher CInstructionMatcher = 
      new LexerMatcher( "CInstruction", @"\#.*" );

    public static readonly LexerMatcher MultiLineCommentMatcher = 
      new LexerMatcher( "MultiLineComment", @"\/\*(.|(\r\n|\r|\n))*?\*\/" ); 

    public static readonly LexerMatcher AnySymbolMatcher = 
      new LexerMatcher( "AnySymbol", @"." );

    public static readonly LexerMatcher HashTag = 
      new LexerMatcher( "HashTag", @"\#(\w|-|\d)+" );

    public static readonly LexerMatcher URL = 
      new LexerMatcher( "URL", @"https?\:\/\/(\w|\.|\-|\?|\=|\+|\/)+" );     
    

    public static readonly LexerMatcher[] Ignore = [
      WhiteSpaceMatcher, BreakMatcher, SingleLineCommentMatcher, MultiLineCommentMatcher
    ];


  }



}