using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;

using System.Globalization;
using Godot;

namespace Rokojori
{
  public class RegexBuilder
  {
    List<string> _parts = new List<string>();
    List<string> _flags = new List<string>();

    public static RegexBuilder Create()
    {
      var rb = new RegexBuilder();
      return rb;
    }

    public RegexBuilder this[ string key ]
    {
      get { _parts.Add( RegexUtility.EscapeForRegex( key ) ); return this; }
    }

    public RegexBuilder _
    {
      get 
      {
         _parts.Add( @"\s*" );
        return this;
      }
    }

    public RegexBuilder __
    {
      get 
      {
         _parts.Add( @"\s+" );
        return this;
      }
    }

    public RegexBuilder Word
    {
      get 
      {
        _parts.Add( @"(\w+)" );
        return this;
      }      
    }

    public RegexBuilder groupStart
    {
      get 
      {
        _parts.Add( "(" );
        return this;
      }      
    }

    public RegexBuilder groupEnd
    {
      get 
      {
        _parts.Add( ")" );
        return this;
      }      
    }

    public RegexBuilder word
    {
      get 
      {
        _parts.Add( @"\w+" );
        return this;
      }
      
    }


    public RegexBuilder flags( string flags )
    {
      for ( int  i = 0 ; i < flags.Length; i++ )
      {
        _flags.Add( flags[ i ] + "" );
      }

      return this;
    }

    public Regex ToRegex()
    {
      var options = RegexOptions.None;
      var pattern = Lists.Join( _parts, "" );

      if ( _flags.IndexOf( "i" ) != -1 )
      {
        options = options | RegexOptions.IgnoreCase;
      }

      if ( _flags.IndexOf( "m" ) != -1 )
      {
        options = options | RegexOptions.Multiline;
      }

      if ( _flags.IndexOf( "y" ) != -1 )
      {
        pattern = RegexUtility.MakeSourceSticky( pattern );
      }

      return new Regex( pattern, options );
    }

  }
}