using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;

using System.Globalization;
using Godot;

namespace Rokojori
{
  public static class RegexExtensions
  {
    public static string Extend( string source )
    {
      //RJLog.Log( "Original:", source );

      // l: Linebreak
      source = RegexUtility.Replace( source, @"\\l", @"(?:\r\n|\r|\n)" );

      // v: Variable
      source = RegexUtility.Replace( source, @"\\v", @"(?:\w|_)+" );

      //RJLog.Log( "Extended:", source );

      return source;
    }
  }
}