using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;

using System.Globalization;
using Godot;

namespace Rokojori
{
  public class RegexMatches
  {
    public Match regexMatch;

    public RegexMatches( Match regexMatch )
    {
      this.regexMatch = regexMatch;
    }

    public string Group( int index )
    {
      if ( regexMatch == null )
      {
        RJLog.Log( "No regexMatch" );
        return null;
      }

       if ( ! regexMatch.Success )
      {
        RJLog.Log( "Not matching" );
        return null;
      }

      if ( regexMatch.Groups.Count <= index )
      {
        RJLog.Log( "Invalid Group Index " + index + ", has only " + regexMatch.Groups.Count );
        return null;
      }
      

      return regexMatch.Groups[ index ].Success ? regexMatch.Groups[ index ].Value : null;
    }
  } 
}