
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;


namespace Rokojori
{
  public static class Text
  {
    public static string GetInnerMatch( this string text, string start, string ending, int offset = 0)
    {
      var startIndex = text.IndexOf( start, offset );

      if ( startIndex == -1 )
      {
        return null;
      }

      var startOffset = startIndex + start.Length;

      var endingIndex = text.IndexOf( ending, startOffset );

      if ( endingIndex == -1 )
      {
        return null;
      }

      return text.Substring( startIndex, ( endingIndex ) - startIndex ); 
    }

    public static string CapitalizeVariable( this string name )
    {
      return ( name[ 0 ] + "" ).ToUpper() + name.Substring( 1 );
    }

     public static string ExtendVariableName( this string before, string next )
    {
      return before + next.CapitalizeVariable();
    }

    public static string MapCharacterToName( this char c )
    {
      if ( char.IsLetter( c ) )
      {
        if ( char.IsUpper( c ) )
        {
          return "uppercase letter " + (c + "").ToLower();
        }

        return "lowercase letter " + c; 
      }

      if ( char.IsNumber( c ) )
      {
        return "number " + c;
      }

      
      var input = c + "";

      
      var result = Regex.Replace( input, @"[!?.\-#+\[\]:,;_/]", 
        m => m.Value switch
        {
          " " => "space",
          "!" => "exclamation mark",
          "?" => "question mark",
          "." => "dot",
          "-" => "minus",
          "+" => "plus",
          "#" => "hash",
          "[" => "opening square bracket",
          "]" => "closing square bracket",
          "{" => "opening curly bracket",
          "}" => "closing curly bracket",
          "(" => "opening round bracket",
          ")" => "closing round bracket",
          ":" => "colon",
          "," => "comma",
          ";" => "semicolon",
          "_" => "underscore",
          "/" => "slash",
          _   => "u" + ( (int) m.Value[ 0 ] ).ToString( "X4" )
        }
      );

      return result;
    }
    public static string WithLeadingZeros( int value, int minDigits = 2 )
    {
      var label = value + "";

      while ( label.Length < minDigits )
      {
        label = "0" + label;
      }

      return label;
    }

    public static string EscapeAsPathForCommandLine( this string path )
    {
      var escaped = path.Replace( "\"", "\\\"" );

      return $"\"{escaped}\"";
    }

    public static string EnsureEndsWith( this string path, string ending )
    {
      if ( ! path.EndsWith( ending ) )
      {
        path += ending;
      }

      return path;
    }

    public static string Replace( this string source, Regex regex, string replacement )
    {
      return regex.Replace( source, replacement );
    }

    public static string SubstringAfterMatching( this string source, string match )
    {
      var index = source.IndexOf( match );

      return index == -1 ? source : source.Substring( index + match.Length );
    }

    public static long ToLong( this string source )
    {
      return long.Parse( source );
    } 

    public static string ReplaceStart( this string source, string start, string replacement = "" )
    {
      if ( source.StartsWith( start ) )
      {
        return replacement + source.Substring( start.Length );
      }

      return source;
    }

    public static string ReplaceEnd( this string source, string ending, string replacement = "" )
    {
      if ( source.EndsWith( ending ) )
      {
        return source.Substring( 0, source.Length - ending.Length ) + replacement;
      }

      return source;
    }

    public static string ExtractCommonStart( this string source, string other )
    {
      for ( int i = 0; i < source.Length && i < other.Length; i++ )
      {
        if ( source[ i ] != other[ i ] )
        {
          return source.Substring( 0, i );
        }
      }

      if ( source.Length < other.Length )
      {
        return source;
      }

      return other;
    }

   
    
    
  }
}