using System.Collections;
using System.Collections.Generic;

namespace Rokojori
{
  public class TextSelection
  {
    TextAnchor _start;
    TextAnchor _end;

    public TextSelection( TextAnchor start, TextAnchor end )
    {
      _start = start.Copy();
      _end = end.Copy();
    }

    public TextAnchor start { get { return _start; } }
    public TextAnchor end { get { return _end; } }
    public TextSelection Copy() { return new TextSelection( start, end ); }

    public bool isOneLine { get { return _start.lineIndex == _end.lineIndex; } }
    public bool isAnchor { get { return isOneLine && _start.characterIndex == _end.characterIndex; } }
    
    public string info
    {
      get
      {
        if ( isAnchor )
        {
          // Output: 12 (1)
          return start.info;
        }

        if ( isOneLine )
        {
          // Output: 12 (1-6) 
          return start.lineIndex + " (" + start.characterIndex + "-" + end.characterIndex + ")"; 
        }

        // Output: 12-15 (3,12) 
        return start.lineIndex + "-" + end.lineIndex + 
        "(" + start.characterIndex + "," + end.characterIndex + ")";
      }
    }
    
  }
  
}