
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public static class DateMath
  {
    public static DateTimeOffset InThePast( int hours )
    {
      return DateTimeOffset.UtcNow.AddHours( - hours );
    }

    public static bool IsNewerThan( this DateTimeOffset a, DateTimeOffset b )
    {
      var difference = GetDifference( a, b ); 
      return difference > 0;
    }

    public static float GetDifference( this DateTimeOffset a, DateTimeOffset b )
    {
      return (float) ( ( a - b ).TotalSeconds );
    }

    public static bool HasExpired( this DateTimeOffset oldTime, float duration )
    {
      var difference = GetDifference( DateTimeOffset.Now, oldTime );

      return difference >= duration;
    }
  }

}