
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [GlobalClass]
  public partial class ISOTimeStamp:Resource
  {
    public string value;

    public static ISOTimeStamp Create( string value )
    {
      var t = new ISOTimeStamp();
      t.value = value;
      return t;
    }

    public static DateTimeOffset ToDate( ISOTimeStamp stamp )
    {    
      return DateTimeOffset.Parse( stamp.value );
    }

    public static ISOTimeStamp FromDate( DateTimeOffset date )
    {
      return Create( date.ToString("o") );
    }

    public static ISOTimeStamp Now()
    {
      return ISOTimeStamp.FromDate( DateTimeOffset.Now );
    }
  }
}