
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class Duration:Resource
  {
    [Export]
    public TimeLine timeLine;
    
    public virtual float GetDurationInSeconds()
    {
      return 0;
    }

    public virtual float GetLoopPosition()
    {
      var tl = TimeLineManager.Ensure( timeLine );

      var duration = GetDurationInSeconds();

      return tl.position % duration;
    }

    public virtual float GetLoopPhase()
    {
      return GetLoopPosition() / GetDurationInSeconds();
    }

    public static string GetTimerLabel( float seconds )
    {
      var secondsAmount = seconds % 60;
      var minutesAmount = ( seconds - secondsAmount ) / 60f;


      var secondsLabel  = Text.WithLeadingZeros( Mathf.CeilToInt( secondsAmount ) );
      var minutesLabel = Text.WithLeadingZeros( Mathf.CeilToInt( minutesAmount ) ); 

      return minutesLabel + ":" + secondsLabel;
    }
  }
}