
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class ModulateTimeLineSpeed : SequenceAction
  {
    [Export]
    public TimeLine timeline;

    [Export]
    public AnimationCurve curve;


    protected override void _OnTrigger()
    {
      var tm = Unique<TimeLineManager>.Get();
      
      if ( tm == null || timeline == null || curve == null )
      {
        return;  
      } 

      var id = DispatchStart();

      tm.Modulate( timeline, curve, r => { DispatchEnd( id ); });     
     
    }

  }
}