
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class TimeLine:Resource
  {
    [Export]
    public bool isLooping = false;
     
    [Export]
    public float loopStart = 0;
    
    [Export]
    public float loopEnd = 100000;
    
    [Export]
    public float startSpeed = 1;

    [Export]
    public bool autoStart = true;

    [Export]
    public bool executesInPause = false;

    public static float osTime => (float)( Time.GetTicksMsec() / 1000.0 );

    public TimeLineRunner runner 
    {
      get 
      {
        var tm = TimeLineManager.Get();

        if ( tm == null )
        {
          return null;
        }

        return tm.GetRunner( this );
      }
    }
        
    public float delta => runner == null ? ( (float)( (SceneTree)Engine.GetMainLoop()).Root.GetProcessDeltaTime() ): runner.currentDelta;

    public float position => runner == null ? Time.GetTicksMsec() / 1000f : runner.position;
    
    public float ComputePhase( float duration, float offset = 0 )
    {
      var time = position + offset;

      return ( time % duration ) / duration;
    }

    public float ComputeRange( float start, float end )
    {
      return MathX.Normalize( position, start, end );
    }

    
  }
}