
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public class TimeLineEvent
  {
    public int id;
    public bool persistent;
    public float position;
    public bool wasInside = false;
    public bool looping = false;
    public float loopDuration = 0;
    public Action<TimeLineEvent> callback;
    public TimeLine timeLine;


    public float GetNextLoopPosition( float timelinePosition )
    {
      return MathAudio.GetNextLoopPosition( timelinePosition, loopDuration, position );
    }

    public float GetPreviousLoopPosition( float timelinePosition )
    {
      return MathAudio.GetPreviousLoopPosition( timelinePosition, loopDuration, position );
    }

  }
}