
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public enum TimeLineSpanUpdateType
  {
    Start,
    InSpan,
    End,
    CompletelyInside
  } 


  public class TimeLineSpan
  {
    public int id;
    public bool persistent;
    public float start;
    public float end;
    public bool wasInside = false;
    public TimeLine timeLine;

    public Action<TimeLineSpan, TimeLineSpanUpdateType> callback;

    public float duration => end - start;

    public float phase 
    {
      get
      {
        var position = timeLine.position;
        return Mathf.Clamp( ( position - start ) / duration, 0, 1 );
      }
    }
  }
}