using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

using System;
using System.Threading.Tasks;

namespace Rokojori
{
  
  public class Async
  {
    public const double waitTime = 1.0 / 60.0;

    public static async Task Wait( double waitTime = Async.waitTime )
    {
      await Task.Delay( (int)( waitTime * 1000 ) );
      return;
    }

    public static double StartTimer()
    {
      return Time.GetTicksMsec() / 1000.0;
    }


    public static double GetTimeMS()
    {
      return Time.GetTicksMsec(); 
    }

    public static double PrintAndUpdateMS( double ms, string info = null )
    {
      var now = GetTimeMS();
      var elapsed = now - ms;

      if ( info != null && info != "" )
      {
        RJLog.Log( "Info:", info, "| Elapsed:", elapsed._DDD(), "Time:", now._DDD() );
      }
      else
      {
        RJLog.Log( "| Elapsed:", elapsed._DDD(), "Time:", now._DDD() );
      }
      

      return now;
    }
   
    public static async Task<double> WaitIfExceeded( double last, double waitTime = Async.waitTime )
    {
      var now = Time.GetTicksMsec() / 1000.0;

      if ( ( now - last ) > waitTime )
      {
        await Task.Delay( (int)( waitTime * 1000 ) );

        return Time.GetTicksMsec() / 1000.0;;
      }

      return last;
    }

    public static async Task<double> WaitIfExceeded( double last, Node node, double waitTime = Async.waitTime )
    {
      var now = Time.GetTicksMsec() / 1000.0;

      if ( ( now - last ) > waitTime )
      {
        await node.RequestNextFrame();

        return Time.GetTicksMsec() / 1000.0;;
      }

      return last;
    }

    public static double DoIfExceeded( double last, System.Action action, double waitTime = Async.waitTime )
    {
      var now = Time.GetTicksMsec() / 1000.0;

      if ( ( now - last ) > waitTime )
      {
        action();
      }


      return Time.GetTicksMsec() / 1000.0;;
    }
  }

}