using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;

namespace Rokojori
{
  public enum BooleanLogicBinaryOperator
  {
    AND,
    OR,
    XOR,
    NOR,
    NAND,
    XNOR    
  }

  public class BooleanLogic
  {
    public static bool Binary( BooleanLogicBinaryOperator op, bool l, bool r )
    {
      switch ( op )
      {
        case BooleanLogicBinaryOperator.AND:  return l && r;
        case BooleanLogicBinaryOperator.OR:   return l || r;
        case BooleanLogicBinaryOperator.XOR:  return l || r && ! ( l && r );
        case BooleanLogicBinaryOperator.NOR:  return ! ( l || r ) ;
        case BooleanLogicBinaryOperator.NAND: return ! ( l && r ) ;
        case BooleanLogicBinaryOperator.XNOR: return ( ! l && ! r ) || ( l && r )  ;
      }

      return false;
    }
  }
}