using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class BoxedFloatValue:Resource
  {

    public virtual float GetFloatValue()
    {
      return 0;
    }

    public virtual void SetFloatValue( float value )
    {
      
    }

    public override string ToString()
    {
      return this.GetType().Name + "( " + RegexUtility.NumberToString( GetFloatValue() ) + " )";
    }

   
    public static void Lerp( BoxedFloatValue a, BoxedFloatValue b, float amount, BoxedFloatValue output )
    {
      if ( a == null || b == null || output == null )
      {
        return;
      }

      output.SetFloatValue( Mathf.Lerp( a.GetFloatValue(), b.GetFloatValue(), amount ) );
    }
  }
}