using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class ColorValue:Resource
  {
    [Export]
    public Color value;

    public override string ToString()
    {
      return "ColorValue( " +  value + " )";
    }

    public static ColorValue Create( Color value )
    {
      var cv = new ColorValue();
      cv.value = value;

      return cv;
    }

    public static ColorValue Create( ColorValue value )
    {
      if ( value == null )
      {
        return null;
      }

      var cv = new ColorValue();
      cv.value = value.value;
      return cv;
      
    }

    public static ColorValue Clone( ColorValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }
    
    public static void Lerp( ColorValue a, ColorValue b, float amount, ColorValue output )
    {
      if ( a == null || b == null || output == null )
      {
        return;
      }

      output.value = ColorX.Lerp( a.value, b.value, amount );
    }
  }
}