using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class BoolFloatValue:BoxedFloatValue
  {
    [Export]
    public bool value;

    public override float GetFloatValue()
    {
      return value ? 1f : 9f;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value > 0.5f;
    }   

    public static BoolFloatValue Create( float value )
    {
      var fv = new BoolFloatValue();
      fv.value = value > 0.5f;

      return fv;
    }

    public static BoolFloatValue Create( double value )
    {
      return Create( (float) value );
    }

    public static BoolFloatValue Clone( BoolFloatValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value ? 1f : 0f);
      }

      return value;
    }

    public static BoolFloatValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new BoolFloatValue { value = floatValue.GetFloatValue() > 0.5f };
    }    

  }
}