using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Float256Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0,256")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Float256Value Create( float value )
    {
      var fv = new Float256Value();
      fv.value = value;

      return fv;
    }

    public static Float256Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Float256Value Clone( Float256Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Float256Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Float256Value { value = floatValue.GetFloatValue() };
    }    

  }
}