using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Float2Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0,2")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Float2Value Create( float value )
    {
      var fv = new Float2Value();
      fv.value = value;

      return fv;
    }

    public static Float2Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Float2Value Clone( Float2Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Float2Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Float2Value { value = floatValue.GetFloatValue() };
    }    

  }
}