using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Float4Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0,4")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Float4Value Create( float value )
    {
      var fv = new Float4Value();
      fv.value = value;

      return fv;
    }

    public static Float4Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Float4Value Clone( Float4Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Float4Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Float4Value { value = floatValue.GetFloatValue() };
    }    

  }
}