using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Float8Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0,8")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Float8Value Create( float value )
    {
      var fv = new Float8Value();
      fv.value = value;

      return fv;
    }

    public static Float8Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Float8Value Clone( Float8Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Float8Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Float8Value { value = floatValue.GetFloatValue() };
    }    

  }
}