using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class FloatDOFDistanceValue:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0.01,8192")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static FloatDOFDistanceValue Create( float value )
    {
      var fv = new FloatDOFDistanceValue();
      fv.value = value;

      return fv;
    }

    public static FloatDOFDistanceValue Create( double value )
    {
      return Create( (float) value );
    }

    public static FloatDOFDistanceValue Clone( FloatDOFDistanceValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static FloatDOFDistanceValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new FloatDOFDistanceValue { value = floatValue.GetFloatValue() };
    }    

  }
}