using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class FloatDOFTransitionValue:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"-1,8192")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static FloatDOFTransitionValue Create( float value )
    {
      var fv = new FloatDOFTransitionValue();
      fv.value = value;

      return fv;
    }

    public static FloatDOFTransitionValue Create( double value )
    {
      return Create( (float) value );
    }

    public static FloatDOFTransitionValue Clone( FloatDOFTransitionValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static FloatDOFTransitionValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new FloatDOFTransitionValue { value = floatValue.GetFloatValue() };
    }    

  }
}