using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Polar1024Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"-1024,1024")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Polar1024Value Create( float value )
    {
      var fv = new Polar1024Value();
      fv.value = value;

      return fv;
    }

    public static Polar1024Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Polar1024Value Clone( Polar1024Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Polar1024Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Polar1024Value { value = floatValue.GetFloatValue() };
    }    

  }
}