using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Polar16Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"-16,16")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Polar16Value Create( float value )
    {
      var fv = new Polar16Value();
      fv.value = value;

      return fv;
    }

    public static Polar16Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Polar16Value Clone( Polar16Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Polar16Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Polar16Value { value = floatValue.GetFloatValue() };
    }    

  }
}