using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Polar2Value:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"-2,2")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static Polar2Value Create( float value )
    {
      var fv = new Polar2Value();
      fv.value = value;

      return fv;
    }

    public static Polar2Value Create( double value )
    {
      return Create( (float) value );
    }

    public static Polar2Value Clone( Polar2Value value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static Polar2Value Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new Polar2Value { value = floatValue.GetFloatValue() };
    }    

  }
}