using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class PolarValue:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"-1,1")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static PolarValue Create( float value )
    {
      var fv = new PolarValue();
      fv.value = value;

      return fv;
    }

    public static PolarValue Create( double value )
    {
      return Create( (float) value );
    }

    public static PolarValue Clone( PolarValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static PolarValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new PolarValue { value = floatValue.GetFloatValue() };
    }    

  }
}