using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class FloatValue:BoxedFloatValue
  {
    [Export]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }   

    public static FloatValue Create( float value )
    {
      var fv = new FloatValue();
      fv.value = value;

      return fv;
    }

    public static FloatValue Create( double value )
    {
      return Create( (float) value );
    }

    public static FloatValue Clone( FloatValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

    public static FloatValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new FloatValue { value = floatValue.GetFloatValue() };
    }    

  }
}