using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class NormalizedValue:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0,1")]
    public float value;

    public override float GetFloatValue()
    {
      return value;
    }

    public override void SetFloatValue( float value )
    {
      this.value = value;
    }

    public static NormalizedValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new NormalizedValue { value = floatValue.GetFloatValue() };
    }
    

    public static NormalizedValue Create( float value )
    {
      var fv = new NormalizedValue();
      fv.value = value;

      return fv;
    }

    
    public static NormalizedValue Create( double value )
    {
      return Create( (float) value );
    }

    public static NormalizedValue Clone( NormalizedValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value );
      }

      return value;
    }

  }
}