using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class PowerValue:BoxedFloatValue
  {
    [Export(PropertyHint.Range,"0,1")]
    public float value;

    [Export(PropertyHint.Range,"0.1,10")]
    public float power = 1.0f;

    public override float GetFloatValue()
    {
      return Mathf.Pow( value, power );
    }

    public override void SetFloatValue( float value )
    {
      this.value = MathX.Base( power, value );
    }

    public static PowerValue Create( BoxedFloatValue floatValue )
    {
      if ( floatValue == null )
      {
        return null;
      }

      return new PowerValue { value = floatValue.GetFloatValue() };
    }
    

    public static PowerValue Create( float value, float power = 1.0f )
    {
      var fv = new PowerValue();
      fv.value = value;
      fv.power = power;

      return fv;
    }

    
    public static PowerValue Create( double value )
    {
      return Create( (float) value );
    }

    public static PowerValue Clone( PowerValue value, bool deepClone )
    {
      if ( deepClone )
      {
        return value == null ? null : Create( value.value, value.power );
      }

      return value;
    }

  }
}