using System.Collections;
using System.Collections.Generic;
using System;
using System.Reflection;
using System.Text.RegularExpressions;

namespace Rokojori
{
  public class Safe
  {
    static readonly int maxWhileIterations = 1000 * 1000;

    public static void While( Func<bool> condition, System.Action action, System.Action onTooManyIterations = null )
    {
      if ( condition == null || action == null )
      {
        return;
      }
      
      var it = 0;

      while ( it < Safe.maxWhileIterations && condition() )
      {
        action();        
        it++;
      }

      if ( it >= Safe.maxWhileIterations )
      {
        RJLog.LogWithFullTrace( "Loop with too many iterations" );

        if ( onTooManyIterations != null )
        {
          onTooManyIterations();
        }
      }


    }
  }
}