using System.Collections;
using System.Collections.Generic;

using Godot;

namespace Rokojori
{
  public class Singleton<T> where T:new()
  {
    private static T _singleton;

    public static T Get()
    {
      if ( _singleton != null )
      {
        return _singleton;
      }

      _singleton = new T();
      
      return _singleton;
    }
  }
}