using System.Collections;
using System.Collections.Generic;
using System;
using System.Reflection;
using System.Text.RegularExpressions;

namespace Rokojori
{
  public enum Trillean
  {
    False,
    True,
    Any
  }

  public static class TrilleanLogic
  {
    public static Trillean FromBool( bool value )
    {
      return value ? Trillean.True : Trillean.False;
    }

    public static bool ToBool( Trillean value, bool any = true )
    {
      if ( Trillean.Any == value )
      {
        return any;
      }

      return Trillean.True == value;
    }

    public static bool Matches( Trillean value, bool state, bool anyValue = true )
    {
      if ( Trillean.Any == value )
      {
        return anyValue;
      }

      var boolValue = Trillean.True == value;

      return boolValue == state;

    }

    public static bool AllAny( params Trillean[] values )
    {
      if ( values == null || values.Length == 0 )
      {
        return false;
      }

      for ( int i = 0; i < values.Length; i++ )
      {
        if ( values[ i ] != Trillean.Any )
        {
          return false;
        }
      }

      return true;
    }
  }
}