
using Godot;
using System;

namespace Rokojori
{ 
  [Tool][GlobalClass] 
  public partial class MouseModeTool : Node
  { 
    public enum EditMode
    {
      Read_Mouse_Mode,
      Write_Mouse_Mode
    }

    [Export]
    public EditMode editMode = EditMode.Read_Mouse_Mode;

    [Export]
    public Input.MouseModeEnum mouseMode = Input.MouseModeEnum.Visible;

    public override void _Process( double delta )
    {
      if ( EditMode.Read_Mouse_Mode == editMode )
      {
        mouseMode = Input.MouseMode;
      }
      else
      {
        Input.MouseMode = mouseMode;
      }
    }
  }
}