
using Godot;
using Rokojori;
using System.Collections.Generic;
 
namespace Rokojori
{ 
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/UIImage.svg")]
  public partial class RoundedRectangleUIImageType:UIImageType
  { 
    Dictionary<UIImage,RoundedRectangleMaterial> _materials = new Dictionary<UIImage, RoundedRectangleMaterial>();

    static readonly string[] colorProperties = [
      RoundedRectangleShader.fillColor.propertyName,
      RoundedRectangleShader.strokeColor.propertyName
    ];

    public override string[] GetColorShaderProperties()
    {
      return colorProperties;
    }

    static readonly string[] numberProperties = [
      RoundedRectangleShader.borderRadius.propertyName,
      RoundedRectangleShader.strokeSize.propertyName,
      RoundedRectangleShader.offset.propertyName
    ];

    public override string[] GetNumberShaderProperties()
    {
      return numberProperties;
    }

    UIColor _fillColor;
    [Export]
    public UIColor fillColor
    {
      get => _fillColor;
      set { _fillColor = value; onChange.DispatchEvent( null ); }
    }

    UIColor _strokeColor;
    [Export]
    public UIColor strokeColor
    {
      get => _strokeColor;
      set { _strokeColor = value; onChange.DispatchEvent( null ); }
    }

    UINumber _borderRadius;
    [Export]
    public UINumber borderRadius
    {
      get => _borderRadius;
      set { _borderRadius = value; onChange.DispatchEvent( null ); }
    }
   
    // TransitionSettings _borderRadiusTransition;
    // [Export]
    // public TransitionSettings borderRadiusTransition
    // {
    //   get => _borderRadiusTransition;
    //   set { _borderRadiusTransition = value; onChange.DispatchEvent( null ); }
    // }

    UINumber _strokeSize;
    [Export]
    public UINumber strokeSize
    {
      get => _strokeSize;
      set { _strokeSize = value; onChange.DispatchEvent( null ); }
    }
   
    // TransitionSettings _strokeSizeTransition;
    // [Export]
    // public TransitionSettings strokeSizeTransition
    // {
    //   get => _strokeSizeTransition;
    //   set { _strokeSizeTransition = value; onChange.DispatchEvent( null ); }
    // }

    UINumber _offset;
    [Export]
    public UINumber offset
    {
      get => _offset;
      set { _offset = value; onChange.DispatchEvent( null ); }
    }
   
    // TransitionSettings _offsetTransition;
    // [Export]
    // public TransitionSettings offsetTransition
    // {
    //   get => _offsetTransition;
    //   set { _offsetTransition = value; onChange.DispatchEvent( null ); }
    // }

    public override UIColor GetUIStyleColorProperty( UIStyleColorProperty property, string shaderPropertyName )
    {
      if ( RoundedRectangleShader.fillColor.propertyName == shaderPropertyName )
      {
        return fillColor;
      }

      if ( RoundedRectangleShader.strokeColor.propertyName == shaderPropertyName )
      {
        return strokeColor;
      }

      return null;
    }

     public override UINumber GetUIStyleNumberProperty( UIStyleNumberProperty property, string shaderPropertyName )
    {
      if ( RoundedRectangleShader.borderRadius.propertyName == shaderPropertyName )
      {
        return borderRadius;
      }

      if ( RoundedRectangleShader.offset.propertyName == shaderPropertyName )
      {
        return offset;
      }

      return null;
    }

    protected override void _Assign( UIImage image )
    {
      if ( _materials.ContainsKey( image ) )
      {
        if ( image.Material == null )
        {
          image.Material = _materials[ image ];
        }

        return;
      }

      _materials[ image ] = new RoundedRectangleMaterial();

      image.Material = _materials[ image ];
      
    }

    protected override void _Clear( UIImage image )
    {
      if ( image != null && _materials.ContainsKey( image ) && image.Material == _materials[ image ] )
      {
        image.Material = null;
      }

      _materials.Remove( image );
      
    }

    protected override void _ApplyChange( UIImage image )
    {
      var material = _materials[ image ];

      // AssignColor( image, material.fillColor, _fillColor );
      // // image.CopyColorShaderPropertyFrom( material.fillColor, GetUIColor( _fillColor, image, material.fillColor.propertyName ) );
      // AssignColor( image, material.strokeColor, _strokeColor );


      // image.CopyNumberShaderPropertyFrom( material.borderRadius, _borderRadius, _borderRadiusTransition );
      // image.CopyNumberShaderPropertyFrom( material.strokeSize, _strokeSize, _strokeSizeTransition );
      // image.CopyNumberShaderPropertyFrom( material.offset, _offset, _offsetTransition );
    }


    


  }
}